/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTable;
import com.mckoi.database.LockingQueue;
import com.mckoi.debug.DebugLogger;

public final class Lock {
    public static final int READ = 0;
    public static final int WRITE = 1;
    private int type;
    private LockingQueue queue;
    private boolean was_checked;
    private final DebugLogger debug;

    Lock(int type, LockingQueue queue, DebugLogger logger) {
        this.debug = logger;
        this.type = type;
        this.queue = queue;
        this.was_checked = false;
        queue.addLock(this);
    }

    int getType() {
        return this.type;
    }

    String getTypeAsString() {
        int type = this.getType();
        if (type == 0) {
            return "READ";
        }
        return "WRITE";
    }

    DataTable getTable() {
        return this.queue.getTable();
    }

    void release() {
        this.queue.removeLock(this);
        if (!this.was_checked) {
            String table_name = this.queue.getTable().getTableName().toString();
            this.debug.write(40, this, "Lock on table '" + this.getTable().getTableName() + "' was released but never checked.  " + this.toString());
            this.debug.writeException(new RuntimeException("Lock Error Dump"));
        }
    }

    void checkAccess(int access_type) {
        if (access_type == 1 && this.type != 1) {
            throw new Error("Access error on Lock: Tried to write to a non write lock.");
        }
        if (!this.was_checked) {
            this.queue.checkAccess(this);
            this.was_checked = true;
        }
    }

    public String toString() {
        return "[Lock] type: " + this.getTypeAsString() + "  was_checked: " + this.was_checked;
    }
}

